<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CandidateProfile extends Model
{
    protected $table = 'candidate_profiles';
    protected $primaryKey = 'Profile_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'First_name',
        'Last_name',
        'Resume_url',
        'Certifications',
        'Location',
        'Experience',
        'bio',
        'age',
        'photo',
        'traits',
        'references',
        'child_age_prefs',
        'verified_by_admin',
        'ratings_avg',
        'is_active',
    ];

    protected $casts = [
        'Certifications' => 'array',
        'Experience' => 'string',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'references' => 'array',
        'verified_by_admin' => 'boolean',
        'ratings_avg' => 'float',
        'is_active' => 'boolean',
        'age' => 'integer',
        'traits' => 'array',
        'child_age_prefs' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    /**
     * Define the one-to-one relationship with the Rate model.
     */
    public function rate()
    {
        return $this->hasOne(Rate::class, 'profile_id', 'Profile_id');
    }

    /**
     * Define the one-to-one relationship with the Availability model.
     */
    public function availability()
    {
        return $this->hasOne(Availability::class, 'profile_id', 'Profile_id');
    }

    /**
     * Define the one-to-one relationship with the AvailableFor model.
     */
    public function availableFor()
    {
        return $this->hasOne(AvailableFor::class, 'profile_id', 'Profile_id');
    }
}
